<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Mail;

use App\error_logs;
use Session;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that should not be reported.
     *
     * @var array
     */
    protected $dontReport = [
        \Illuminate\Auth\AuthenticationException::class,
        \Illuminate\Auth\Access\AuthorizationException::class,
        \Symfony\Component\HttpKernel\Exception\HttpException::class,
        \Illuminate\Database\Eloquent\ModelNotFoundException::class,
        \Illuminate\Session\TokenMismatchException::class,
        \Illuminate\Validation\ValidationException::class,
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        if($this->isHttpException($exception))
        {
            switch ($exception->getStatusCode()) 
                {
                // not found
                case 404:
                return redirect('/Error');
                break;

                // internal error
                case '500':
                return redirect('/Error');
                break;

                default:
                   //return $this->renderHttpException($exception);
                   return redirect('Error');
                break;
            }
        }
        elseif(isset($exception->validator))
        {
         return parent::render($request, $exception);
        }
        else
        {
            ////////// ENABLE THIS TO SHOW ERRORS
            //dd($exception);
            //return parent::render($request, $exception);
            
            // $query = new error_logs();
            // $query->exception = $exception->getMessage();
            // $query->file = $exception->getFile();
            // $query->line = $exception->getLine();
            // $query->save();
            // Session::put('message',$exception->getMessage());
            // Session::put('file',$exception->getFile());
            // Session::put('line',$exception->getLine());
            // return redirect('SystemFailure');
            return parent::render($request, $exception);
        }
        //return redirect('Error');
    }

    /**
     * Convert an authentication exception into an unauthenticated response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Illuminate\Auth\AuthenticationException  $exception
     * @return \Illuminate\Http\Response
     */
    protected function unauthenticated($request, AuthenticationException $exception)
    {
        if ($request->expectsJson()) {
            return response()->json(['error' => 'Unauthenticated.'], 401);
        }

        return redirect()->guest(route('/'));
    }
}
