<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Session;
class JobValidation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
           'phone_number' => 'numeric|nullable',
           'short_description' => 'max:45|nullable',
           'long_description' => 'max:250|nullable',
           'additional_notes' => 'max:200|nullable',
        ];
    }

   protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        Session::flash('error','Please validate all fields');
        return parent::failedValidation($validator);
    }
}
