<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->string('first_name');
            $table->string('last_name');
            $table->date('dob');
            $table->string('home_address');
            $table->string('corresp_address');
            $table->string('phone_no');
            $table->string('email');
            $table->string('national_insurance_no');
            $table->string('emp_no');
            $table->date('emp_start_date');
            $table->date('emp_end_date');
            $table->string('emp_type');
            $table->string('personal_bank_name');
            $table->string('bank_sort_code');
            $table->string('bank_account_no');
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('staff');
    }
}
