<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAgenciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agencies', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->string('company_re_name');
            $table->string('company_trading_name');
            $table->string('company_re_no');
            $table->string('company_vat_no');
            $table->string('address_line1');
            $table->string('address_line2');
            $table->string('address_line3');
            $table->string('town');
            $table->string('county');
            $table->string('post_code');
            $table->string('web_address');
            $table->string('person_name');
            $table->string('email');
            $table->string('phone_no1');
            $table->string('phone_no2');
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agencies');
    }
}
