<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('phone_no');
            $table->string('email');
            $table->string('address_line1');
            $table->string('address_line2');
            $table->string('address_line3');
            $table->string('town');
            $table->string('county');
            $table->string('post_code');
            $table->string('proposed_com_name');
            $table->date('dob');
            $table->string('national_insurance_no');
            $table->string('town_birth');
            $table->string('mother_maiden_name');
            $table->string('name_agency');
            $table->string('agency_email');
            $table->string('agency_phone_no');
            $table->string('passport');
            $table->string('driving_license');
            $table->string('quilification_card');
            $table->string('driver_card');
            $table->string('training_cirtificate');
            $table->string('public_laibility_insurance');
            $table->string('driving_experience');
            $table->string('personal_bank_name');
            $table->string('bank_sort_code');
            $table->string('bank_account_no');
            $table->string('hear_about_us');
            $table->string('referred_by');
            $table->string('status')->default(0);





            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drivers');
    }
}
