<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([

    'middleware' => 'api',
    'prefix' => 'v1'

], function ($router) {

    Route::post('logout', 'AuthController@logout');
    Route::post('refresh', 'AuthController@refresh');
    Route::post('me', 'AuthController@me');
});
Route::get('sendNotification/{id}/{user_type}/{title}/{message?}', 'AuthController@sendNotification');
Route::post('device', 'AuthController@device');
Route::post('login', 'AuthController@login');
Route::post('signup', 'AuthController@signup');
Route::post('confirmEmail', 'AuthController@confirmEmail');
Route::post('verifyManager', 'AuthController@verifyManager');
Route::post('verifyEmployee', 'AuthController@verifyEmployee');
Route::post('resetPassword', 'AuthController@resetPassword');
Route::post('employee_login', 'AuthController@employee_login');
Route::post('employeeConfirmEmail', 'AuthController@employeeConfirmEmail');
Route::post('employeeResetPassword', 'AuthController@employeeResetPassword');

// main routes
Route::get('getDashboardData/{id}', 'EmployeeController@getDashboardData');

// projects
Route::get('allProjectsForManager/{id}', 'ProjectController@allProjectsForManager');
Route::get('allProjectsForEmployee/{id}', 'ProjectController@allProjectsForEmployee');
Route::get('getProjectFormData/{id}', 'ProjectController@getProjectFormData');
Route::post('addNewTask/{id}/{check}', 'ProjectController@addNewTask');
Route::get('deleteFile/{id}/{index}', 'ProjectController@deleteFile');
Route::get('deleteProject/{id}', 'ProjectController@deleteProject');
Route::get('completeProject/{task_id}/{id}', 'ProjectController@completeProject');
Route::get('deleteAddedEmployee/{id}', 'ProjectController@deleteAddedEmployee');

// jobs
Route::get('getJobsByEmployeeId/{id}', 'ProjectController@getJobsByEmployeeId');
Route::get('getAllJobs/{id}', 'ProjectController@getAllJobs');
Route::post('addJob', 'ProjectController@addJob');
Route::post('updateJob/{id}', 'ProjectController@updateJob');
Route::get('deleteJob/{id}/{user_id}', 'ProjectController@deleteJob');

// buildings
Route::get('getBuildByEmployeeId/{id}', 'ProjectController@getBuildByEmployeeId');
Route::get('getAllBuildings/{id}', 'ProjectController@getAllBuildings');
Route::post('addBuilding', 'ProjectController@addBuilding');
Route::post('updateBuilding/{id}', 'ProjectController@updateBuilding');
Route::get('deleteBuilding/{id}', 'ProjectController@deleteBuilding');

// Employee Form
Route::get('getEmployeeFormData/{id}', 'EmployeeController@getEmployeeFormData');
Route::post('addEmployee/{id}', 'EmployeeController@addEmployee');
Route::post('updateEmployee/{id}', 'EmployeeController@updateEmployee');
Route::post('updateEmployeeProfile/{id}', 'EmployeeController@updateEmployeeProfile');
Route::get('getEmployees/{id}', 'EmployeeController@getEmployees');
Route::get('deleteEmployee/{id}', 'EmployeeController@deleteEmployee');

// messages
Route::get('getMyMessages/{id}', 'EmployeeController@getMyMessages');
Route::get('getConversations/{id}/{man_id?}', 'EmployeeController@getConversations');
Route::get('getReplies/{id}/{man_id?}', 'EmployeeController@getReplies');
Route::post('addNewReply', 'EmployeeController@addNewReply');



Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
