<?php

// use App\Http\Controllers\Auth\LoginController;
// use App\Http\Controllers\Auth\RegisterController;

ini_set('session.save_path',realpath(dirname($_SERVER['DOCUMENT_ROOT']) . '/../session'));
session_start();

if (!isset($_SESSION['adminController'])) {

    $_SESSION['adminController'] = 0;
    $_SESSION['Accountancy'] = 0;
    $_SESSION['RouteCheckee'] = 0;
}

/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/
////////////////////////////////  DATATABLE ROUTES //////////////////////////
            Route::post('/datatable_driverown', 'AdminController@datatable_driverown');
            Route::post('/datatable_WT', 'AdminController@datatable_WT');
            Route::post('/datatable_enhanced_driver', 'AdminController@datatable_enhanced_driver');
            Route::post('/datatable_agency_self_bill', 'AdminController@datatable_agency_self_bill');
            Route::post('/datatable_driverinvoice', 'AdminController@datatable_driverinvoice');



//////////////////////////////// APP API /////////////////////////////////////

Route::get('React/test', 'TestController@react');



Route::get('CryptedHash/{id}', 'AdminController@CryptedHash');
Route::get('FirebaseNotification', 'AdminController@FirebaseNotification');

Route::get('AppRegister', 'AdminController@AppRegister');

Route::get('AppChange/{email}/{String1}/{String2}/{String3}', 'AdminController@AppChange');

Route::get('AppLogin/{Username}/{ID}', 'LoginController@APPLogin');

Route::get('FireBaseToken/{Email}/{Token}/{Device}', 'AdminController@FireBaseToken');

Route::get('resetpassApp/{email}/{Check?}', 'LoginController@resetpassApp');

Route::get('AppVerifyMobile/{Email}/{Code}', 'LoginController@AppVerifyMobile');

Route::get('SetPassword/{Email}/{cPass}/{nPass}', 'LoginController@SetPassword');

Route::get('UpdateSession/{ID}/{Check}', 'LoginController@UpdateSession');

Route::get('Form', 'AdminController@Form');

Route::get('FetchProfile/{ID}/{Check}', 'AdminController@FetchProfile');

Route::get('FetchDashbaord/{ID}/{Check}', 'AdminController@FetchDashbaord');

Route::get('VerifyAccountApp/{ID}/{Check}', 'AdminController@VerifyAccountApp');

Route::get('getagencies/{ID}', 'AdminController@getagencies');

Route::get('getagenciesnew/{ID}', 'AdminController@getagenciesnew');

Route::get('getagenciesnew/Filter/{ID}', 'AdminController@getagenciesnewFilter');

Route::get('singleagencies/{ID}', 'AdminController@singleagencies');

Route::get('getdrivers/{ID}', 'AdminController@getdrivers');

Route::get('FetchAllowances', 'AdminController@FetchAllowances');

Route::get('SubmitExpenseSheet', 'AdminController@SubmitExpenseSheet');

Route::get('ListExpenseSheet/{ID}/{Check}', 'AdminController@ListExpenseSheet');

Route::get('ListTimesheet/{ID}/{Check}', 'AdminController@ListTimesheet');

Route::get('ListIncomeForms/{ID}/{Check}', 'AdminController@ListIncomeForms');

Route::get('ListJobs/{ID}/{Check}', 'AdminController@ListJobs');

Route::get('JobStatus/{DriverID}/{ID}/{Check}/{NewID}', 'AdminController@JobStatus');

Route::get('JobStatusPortal/{ID}/', 'AdminController@JobStatusPortal');

Route::get('ListJobsLimited/{ID}/{Check}', 'AdminController@ListJobsLimited');

Route::get('SingleExpenseSheet/{ID}', 'AdminController@SingleExpenseSheet');

Route::get('DeleteExpenseSheet/{ID}', 'AdminController@DeleteExpenseSheet');

Route::get('DeleteTimesheet/{ID}', 'AdminController@DeleteTimesheet');

Route::get('IncomeDelete/{ID}', 'AdminController@IncomeDelete');

Route::get('SingleTimeSheet/{ID}', 'AdminController@SingleTimeSheet');

Route::get('SingleIncomeForm/{ID}', 'AdminController@SingleIncomeForm');

Route::get('SingleJob/{ID}', 'AdminController@SingleJob');

Route::get('SubmitTimesheet', 'AdminController@SubmitTimesheet');

Route::get('SubmitIncomForm', 'AdminController@SubmitIncomForm');

Route::get('DriverFileSession/{Type}/{ID}', 'AdminController@DriverFileSession');

Route::get('DriverFileSessionApp/{Type}/{ID}', 'AdminController@DriverFileSessionApp');

Route::get('DriverFile', 'AdminController@DriverFile');

Route::get('fetchemails/{Check}', 'AdminController@fetchemails');

Route::post('FinalSubmitSelfBill', 'AdminController@FinalSubmitSelfBill');

Route::post('AddJobDriver', 'AdminController@AddJobDriver');

Route::get('AppAssignedDrivers/{Check}/{ID}/{LoginID}', 'AdminController@AppAssignedDrivers');

Route::get('WebAssignedDrivers/{Check}/{LoginID}', 'AdminController@WebAssignedDrivers');

Route::get('AssignedDriversUpdate/{Check}/{ID}/{LoginID}', 'AdminController@AssignedDriversUpdate');

Route::get('PrivateJobCheck/{JobID}/{LoginID}', 'AdminController@PrivateJobCheck');

/////////////////////////////////////////////////////////////////////////////


/////////////////////////////// GENERAL ROUTES /////////////////////////////////







Route::get('/', function () {

    return view('login');
});



Route::post('login', 'LoginController@login');

Route::post('/reset', 'LoginController@resetpass');

Route::get('/reset/{ID}', 'LoginController@resetpassApp');

Route::get('/SetPass/{credentials}', 'LoginController@SetPass');

Route::get('/ChangePasswordNew/', 'LoginController@getChangepasswordNew');

Route::post('/ChangePassNew/', 'LoginController@ChangePassNew');

Route::get('forgot', function () {

    return view('forgot');
});



Route::get('Error', 'AdminController@showerror');



Route::get('SystemFailure', 'AdminController@SystemFailure');



Route::get('SetPass/{Credentials}', 'LoginController@SetPass');



Route::get('/ChangePasswordNew/', 'LoginController@getChangepasswordNew');



Route::post('/ChangePassNew/', 'LoginController@ChangePassNew');



Route::get('/logout/', 'LoginController@logout');



Route::post('ChangePass', 'LoginController@ChangePass');



Route::get('/Activate/{credentials}', 'LoginController@activate');



Route::get('/Dashboard', [



    'uses' => 'AdminController@index',

    'as' => 'Home'



]);


Route::get('/StatusChange/{Value}/{ID}', [



    'uses' => 'AdminController@StatusChange',

    'as' => 'StatusChange'



]);



Route::get('/Profile', [



    'uses' => 'AdminController@profile',

    'as' => 'Profile'



]);

Route::get('/Register', [



    'uses' => 'AdminController@register',

    'as' => 'Register'



]);


Route::get('/ValidateAccount', [



    'uses' => 'AdminController@ValidateAccount',

    'as' => 'ValidateAccount'



]);

Route::get('/DeleteDoc/{ID}', [



    'uses' => 'AdminController@DeleteDoc',

    'as' => 'DeleteDoc'



]);

Route::post('/ValidateAccount', [



    'uses' => 'AdminController@ValidateAccountSubmit',

    'as' => 'ValidateAccount'



]);


Route::get('/VerifyAccount/{string}/{string1}', [



    'uses' => 'AdminController@ValidateAccountSubmitNews',

    'as' => 'ValidateAccount'



]);


Route::post('/RegisterSubmit', [



    'uses' => 'AdminController@RegisterSubmit',

    'as' => 'Register'



]);

Route::post('/ValidateSubmit', [



    'uses' => 'AdminController@ValidateSubmit',

    'as' => 'ValidateSubmit'



]);


Route::get('/ResendCode/{Email}/{Phone}/{Check?}', [



    'uses' => 'AdminController@ResendCode',

    'as' => 'ResendCode'



]);


////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////



Route::get('/fileSystem/{check}/{id}', 'AdminController@fileSystem');




///////////////////////////////// SUPERADMIN ///////////////////////////////////



Route::group(['middleware' => 'superadmin'], function () {

    if ($_SESSION['adminController'] == 1) {
        ////////////////////////// ADMIN ROUTES ///////////////////////

        //////////////////// Bulk Routes ////////////////////
        Route::post('Deleteadminbulk', [

            'uses' => 'AdminController@deleteadminbulk',

            'as' => 'deleteadminbulk'

        ]);

        Route::post('activateadminbulk', [

            'uses' => 'AdminController@activateadminbulk',

            'as' => 'activateadminbulk'

        ]);
        Route::post('deactivateadminbulk', [

            'uses' => 'AdminController@deactivateadminbulk',

            'as' => 'deactivateadminbulk'

        ]);
        Route::post('deletejobbulk', [

            'uses' => 'AdminController@deletejobbulk',

            'as' => 'deletejobbulk'

        ]);
        Route::post('activatejobbulk', [

            'uses' => 'AdminController@activatejobbulk',

            'as' => 'activatejobbulk'

        ]);
        Route::post('deactivatejobbulk', [

            'uses' => 'AdminController@deactivatejobbulk',

            'as' => 'deactivatejobbulk'

        ]);
        Route::post('Deletestaffbulk', [

            'uses' => 'AdminController@deletestaffbulk',

            'as' => 'Deletestaffbulk'

        ]);
        Route::post('activatestaffbulk', [

            'uses' => 'AdminController@activatestaffbulk',

            'as' => 'activatestaffbulk'

        ]);
        Route::post('deactivatestaffbulk', [

            'uses' => 'AdminController@deactivatestaffbulk',

            'as' => 'deactivatestaffbulk'

        ]);
        Route::post('deleteagencybulk', [

            'uses' => 'AdminController@deleteagencybulk',

            'as' => 'deleteagencybulk'

        ]);
        Route::post('deactivateagencybulk', [

            'uses' => 'AdminController@deactivateagencybulk',

            'as' => 'deactivateagencybulk'

        ]);
        Route::post('activateagencybulk', [

            'uses' => 'AdminController@activateagencybulk',

            'as' => 'activateagencybulk'

        ]);
        Route::post('deactivatedriverbulk', [

            'uses' => 'AdminController@deactivatedriverbulk',

            'as' => 'deactivatedriverbulk'

        ]);
        Route::post('activatedriverbulk', [

            'uses' => 'AdminController@activatedriverbulk',

            'as' => 'activatedriverbulk'

        ]);
        Route::post('deletedriverbulk', [

            'uses' => 'AdminController@deletedriverbulk',

            'as' => 'deletedriverbulk'

        ]);

        if ($_SESSION['Accountancy'] == 1) {

            Route::post('activateallowancesbulk', [

                'uses' => 'AdminController@activateallowancesbulk',

                'as' => 'activateallowancesbulk'

            ]);
            Route::post('deactivateallowancesbulk', [

                'uses' => 'AdminController@deactivateallowancesbulk',

                'as' => 'deactivateallowancesbulk'

            ]);
            Route::post('Deleteallowancesbulk', [

                'uses' => 'AdminController@Deleteallowancesbulk',

                'as' => 'Deleteallowancesbulk'

            ]);
            Route::post('deactivatetimeshetsbulk', [

                'uses' => 'AdminController@deactivatetimeshetsbulk',

                'as' => 'deactivatetimeshetsbulk'

            ]);
            Route::post('activatetimeshetsbulk', [

                'uses' => 'AdminController@activatetimeshetsbulk',

                'as' => 'activatetimeshetsbulk'

            ]);
            Route::post('deletetimeshetsbulk', [

                'uses' => 'AdminController@deletetimeshetsbulk',

                'as' => 'deletetimeshetsbulk'

            ]);
            Route::post('deactivateexpensebulk', [

                'uses' => 'AdminController@deactivateexpensebulk',

                'as' => 'deactivateexpensebulk'

            ]);
            Route::post('activateexpensebulk', [

                'uses' => 'AdminController@activateexpensebulk',

                'as' => 'activateexpensebulk'

            ]);
            Route::post('deleteexpensebulk', [

                'uses' => 'AdminController@deleteexpensebulk',

                'as' => 'deleteexpensebulk'

            ]);
        }
        ////////////////////////////////////////

        Route::get('SendEmail', [
            'uses' => 'AdminController@SendEmail',
            'as' => 'SendEmail'
        ]);

        Route::post('SendEmailSubmit', [
            'uses' => 'AdminController@SendEmailSubmit',
            'as' => 'SendEmailSubmit'
        ]);

        Route::get('AddAdmin', [

            'uses' => 'AdminController@addadmin',

            //'as'=>'addstaff'

        ]);



        Route::get('AllAdmins', [

            'uses' => 'AdminController@alladmins',

            //'as'=>'addstaff'

        ]);

        Route::post('datatable_alladmins', 'AdminController@datatable_alladmins');


        Route::get('Deleteadmin/{id}', [

            'uses' => 'AdminController@deleteadmin',

            'as' => 'deleteadmin'



        ]);

        Route::get('HGV_Details', [

            'uses' => 'AdminController@HGV_Details',

            'as' => 'HGV_Details'

        ]);

        Route::post('UPDATEHGVDETAILS', [

            'uses' => 'AdminController@UPDATEHGVDETAILS',

            'as' => 'UPDATEHGVDETAILS'

        ]);



        Route::get('activateadmin/{id}', [

            'uses' => 'AdminController@activateadmin',

            'as' => 'activateadmin'



        ]);



        Route::get('deactivateadmin/{id}', [

            'uses' => 'AdminController@deactivateadmin',

            'as' => 'deactivateadmin'



        ]);



        Route::get('editadmin/{id}', [

            'uses' => 'AdminController@editadmin',

            'as' => 'editadmin'



        ]);



        Route::post('Updateadmin/{id}', [

            'uses' => 'AdminController@Updateadmin',

            'as' => 'Updateadmin'



        ]);



        Route::post('STOREADMIN', [

            'uses' => 'AdminController@STOREADMIN',

            'as' => 'STOREADMIN'

        ]);

        ///////////////////////// JOBS ///////////////////////////////


        Route::get('Addjob', [

            'uses' => 'AdminController@addjob',

            //'as'=>'addstaff'

        ]);



        Route::get('Alljobs', [

            'uses' => 'AdminController@alljobs',

            //'as'=>'addstaff'

        ]);



        Route::get('deletejob/{id}', [

            'uses' => 'AdminController@deletejob',

            'as' => 'deletejob'

        ]);



        Route::get('activatejob/{id}', [

            'uses' => 'AdminController@activatejob',

            'as' => 'activatejob'



        ]);




        Route::get('deactivatejob/{id}', [

            'uses' => 'AdminController@deactivatejob',

            'as' => 'deactivatejob'



        ]);



        Route::get('editjob/{id}', [

            'uses' => 'AdminController@editjob',

            'as' => 'editjob'



        ]);



        Route::post('Updatejob', [

            'uses' => 'AdminController@Updatejob',

            'as' => 'Updatejob'



        ]);



        Route::post('STOREjob', [

            'uses' => 'AdminController@STOREjob',

            'as' => 'STOREjob'

        ]);



        ////////////////////////////// STAFF ///////////////////////////



        Route::get('AddStaff', [

            'uses' => 'AdminController@staff',

            'as' => 'addstaff'

        ]);



        Route::post('STORESTAFF', [

            'uses' => 'AdminController@STORESTAFF',

            'as' => 'STORESTAFF'

        ]);



        Route::get('AllStaff', [

            'uses' => 'AdminController@allstaff',

            'as' => 'allstaff'

        ]);



        Route::post('datatable_allstaff', [

            'uses' => 'AdminController@datatable_allstaff',

            'as' => 'datatable_allstaff'

        ]);



        Route::get('Deletestaff/{id}', [

            'uses' => 'AdminController@deletestaff',

            'as' => 'deletestaff'



        ]);



        Route::get('activatestaff/{id}', [

            'uses' => 'AdminController@activatestaff',

            'as' => 'activatestaff'



        ]);



        Route::get('deactivatestaff/{id}', [

            'uses' => 'AdminController@deactivatestaff',

            'as' => 'deactivatestaff'



        ]);



        Route::get('editstaff/{id}', [

            'uses' => 'AdminController@editstaff',

            'as' => 'editstaff'



        ]);



        Route::post('Updatestaff/{id}', [

            'uses' => 'AdminController@Updatestaff',

            'as' => 'Updatestaff'



        ]);



        //agency section starting form here



        Route::get('AddAgency', [

            'uses' => 'AdminController@agency',

            'as' => 'addagency'

        ]);



        Route::post('STOREAGENCY', [

            'uses' => 'AdminController@STOREAGENCY',

            'as' => 'STOREAGENCY'

        ]);



        Route::post('STORESTAFF', [

            'uses' => 'AdminController@STORESTAFF',

            'as' => 'STORESTAFF'

        ]);



        Route::get('AllAgencies', [

            'uses' => 'AdminController@allagencies',

            'as' => 'allagencies'

        ]);

        Route::post('datatable_allagencies', [

            'uses' => 'AdminController@datatable_allagencies',

            'as' => 'datatable_allagencies'

        ]);

        Route::get('AllAgenciesIn', [

            'uses' => 'AdminController@allagenciesin',

            'as' => 'allagenciesin'

        ]);



        Route::get('deleteagency/{id}', [

            'uses' => 'AdminController@deleteagency',

            'as' => 'deleteagency'

        ]);



        Route::get('editagency/{id}', [

            'uses' => 'AdminController@editagency',

            'as' => 'editagency'

        ]);



        Route::post('updateagency/{id}', [

            'uses' => 'AdminController@updateagency',

            'as' => 'updateagency'

        ]);



        Route::get('deactivateagency/{id}', [

            'uses' => 'AdminController@deactivateagency',

            'as' => 'deactivateagency'

        ]);



        Route::get('activateagency/{id}', [

            'uses' => 'AdminController@activateagency',

            'as' => 'activateagency'

        ]);

        //ending agency section here



        //driver methods stargin form here====================>

        Route::get('AllDrivers', [

            'uses' => 'AdminController@alldrivers',

            'as' => 'alldrivers'

        ]);

        Route::post('datatable_alldrivers', 'AdminController@datatable_alldrivers');

        Route::get('CHDetails/{Check}/{MainID}/{ID?}', [

            'uses' => 'AdminController@CHDetails',

            'as' => 'CHDetails'

        ]);

        // Route::get('CHDetails/{ID}',[

        // 'uses'=>'AdminController@CHDetails_Submit',

        // 'as'=>'CHDetails'

        // ]);


        Route::get('AllDriversIn', [

            'uses' => 'AdminController@alldriversin',

            'as' => 'alldriversin'

        ]);



        Route::post('storedrivers', [

            'uses' => 'AdminController@storedrivers',

            'as' => 'storedrivers'

        ]);



        Route::get('AddDrivers', [

            'uses' => 'AdminController@adddrivers',

            'as' => 'adddrivers'

        ]);


        Route::get('Devices', [

            'uses' => 'AdminController@Devices',

            'as' => 'Devices'

        ]);

        Route::get('DeleteDevice/{ID}', [

            'uses' => 'AdminController@DeleteDevice',

            'as' => 'DeleteDevice'

        ]);



        Route::get('deactivatedriver/{id}', [

            'uses' => 'AdminController@deactivatedriver',

            'as' => 'deactivatedriver'

        ]);



        Route::get('activatedriver/{id}', [

            'uses' => 'AdminController@activatedriver',

            'as' => 'activatedriver'

        ]);



        Route::get('deletedriver/{id}', [

            'uses' => 'AdminController@deletedriver',

            'as' => 'deletedriver'

        ]);



        Route::get('editdriver/{id}', [

            'uses' => 'AdminController@editdriver',

            'as' => 'editdriver'



        ]);



        Route::post('Updatedriver/{id}', [

            'uses' => 'AdminController@Updatedriver',

            'as' => 'Updatedriver'



        ]);



        Route::get('DriverProfile/{id}', [

            'uses' => 'AdminController@DriverProfile',

            'as' => 'DriverProfile'



        ]);



        Route::get('ErrorLogs/', [

            'uses' => 'AdminController@ErrorLogs',

            'as' => 'ErrorLogs'



        ]);

        Route::get('Allowances/', [

            'uses' => 'AdminController@Allowances',

            'as' => 'Allowances Settings'

        ]);

        Route::get('ListAllowances/', [

            'uses' => 'AdminController@ListAllowances',

            'as' => 'Allowances Settings'

        ]);

        Route::get('Deleteallowances/{id}', [

            'uses' => 'AdminController@deleteallowances',

            'as' => 'deleteallowances'



        ]);


        if ($_SESSION['Accountancy'] == 1) {

            Route::get('activateallowances/{id}', [

                'uses' => 'AdminController@activateallowances',

                'as' => 'activateallowances'



            ]);



            Route::get('deactivateallowances/{id}', [

                'uses' => 'AdminController@deactivateallowances',

                'as' => 'deactivateallowances'



            ]);

            Route::get('EditAllowances/{ID}', 'AdminController@EditAllowances');

            Route::post('AddAllowances', 'AdminController@AddAllowances');


            Route::get('deactivatetimeshets/{id}', [

                'uses' => 'AdminController@deactivatetimeshets',

                'as' => 'deactivatetimeshets'

            ]);



            Route::get('activatetimeshets/{id}', [

                'uses' => 'AdminController@activatetimeshets',

                'as' => 'activatetimeshets'

            ]);



            Route::get('deletetimeshets/{id}', [

                'uses' => 'AdminController@deletetimeshets',

                'as' => 'deletetimeshets'

            ]);



            Route::get('edittimesheets/{Type}/{id}', [

                'uses' => 'AdminController@edittimeshets',

                'as' => 'edittimeshets'



            ]);

            Route::get('Attachment/{ID}', [

                'uses' => 'AdminController@Attachment',

                'as' => 'Attachment'



            ]);



            Route::post('Updatetimeshets/{id}', [

                'uses' => 'AdminController@Updatetimeshets',

                'as' => 'Updatetimeshets'



            ]);

            Route::get('Invoice/{Check}/{ID}', 'AdminController@Invoice');

            Route::get('invoiced/{ID}/{Check}', 'AdminController@invoiced');



            Route::get('deactivatecertified/{id}', [

                'uses' => 'AdminController@deactivatecertified',

                'as' => 'deactivatecertified'

            ]);



            Route::get('activatecertified/{id}', [

                'uses' => 'AdminController@activatecertified',

                'as' => 'activatecertified'

            ]);



            Route::get('deletecertified/{id}', [

                'uses' => 'AdminController@deletecertified',

                'as' => 'deletecertified'

            ]);



            Route::get('editcertified/{id}', [

                'uses' => 'AdminController@editcertified',

                'as' => 'editcertified'



            ]);



            Route::post('Updatecertified/{id}', [

                'uses' => 'AdminController@Updatecertified',

                'as' => 'Updatecertified'



            ]);



            Route::get('deactivateexpense/{id}', [

                'uses' => 'AdminController@deactivateexpense',

                'as' => 'deactivateexpense'

            ]);



            Route::get('activateexpense/{id}', [

                'uses' => 'AdminController@activateexpense',

                'as' => 'activateexpense'

            ]);



            Route::get('deleteexpense/{id}', [

                'uses' => 'AdminController@deleteexpense',

                'as' => 'deleteexpense'

            ]);



            Route::get('editexpense/{id}', [

                'uses' => 'AdminController@editexpense',

                'as' => 'editexpense'



            ]);



            Route::post('Updateexpense/{id}', [

                'uses' => 'AdminController@Updateexpense',

                'as' => 'Updateexpense'



            ]);


            Route::get('/HGVAccountancy', 'AdminController@WT');

            Route::get('/EnhancedDriver', 'AdminController@EnhancedDriver');

            Route::get('/driverown', 'AdminController@driverown');

            Route::get('/DriverInvoice', 'AdminController@DriverInvoice');

            Route::get('/agencyselfbill', 'AdminController@agencyselfbill');

            Route::get('/WIE', 'AdminController@WIE');


            Route::get('/MES', 'AdminController@MES');
        }
    }
});



//////////////////////////////// STAFF ////////////////////////////////////////



Route::group(['middleware' => 'staff'], function () {

    if ($_SESSION['adminController'] == 2) {

        //////////////////// Bulk Routes ////////////////////
        Route::post('Deleteadminbulk', [

            'uses' => 'AdminController@deleteadminbulk',

            'as' => 'deleteadminbulk'

        ]);

        Route::post('activateadminbulk', [

            'uses' => 'AdminController@activateadminbulk',

            'as' => 'activateadminbulk'

        ]);
        Route::post('deactivateadminbulk', [

            'uses' => 'AdminController@deactivateadminbulk',

            'as' => 'deactivateadminbulk'

        ]);
        Route::post('deletejobbulk', [

            'uses' => 'AdminController@deletejobbulk',

            'as' => 'deletejobbulk'

        ]);
        Route::post('activatejobbulk', [

            'uses' => 'AdminController@activatejobbulk',

            'as' => 'activatejobbulk'

        ]);
        Route::post('deactivatejobbulk', [

            'uses' => 'AdminController@deactivatejobbulk',

            'as' => 'deactivatejobbulk'

        ]);
        Route::post('Deletestaffbulk', [

            'uses' => 'AdminController@deletestaffbulk',

            'as' => 'Deletestaffbulk'

        ]);
        Route::post('activatestaffbulk', [

            'uses' => 'AdminController@activatestaffbulk',

            'as' => 'activatestaffbulk'

        ]);
        Route::post('deactivatestaffbulk', [

            'uses' => 'AdminController@deactivatestaffbulk',

            'as' => 'deactivatestaffbulk'

        ]);
        Route::post('deleteagencybulk', [

            'uses' => 'AdminController@deleteagencybulk',

            'as' => 'deleteagencybulk'

        ]);
        Route::post('deactivateagencybulk', [

            'uses' => 'AdminController@deactivateagencybulk',

            'as' => 'deactivateagencybulk'

        ]);
        Route::post('activateagencybulk', [

            'uses' => 'AdminController@activateagencybulk',

            'as' => 'activateagencybulk'

        ]);
        Route::post('deactivatedriverbulk', [

            'uses' => 'AdminController@deactivatedriverbulk',

            'as' => 'deactivatedriverbulk'

        ]);
        Route::post('activatedriverbulk', [

            'uses' => 'AdminController@activatedriverbulk',

            'as' => 'activatedriverbulk'

        ]);
        Route::post('deletedriverbulk', [

            'uses' => 'AdminController@deletedriverbulk',

            'as' => 'deletedriverbulk'

        ]);

        if ($_SESSION['Accountancy'] == 1) {

            Route::post('activateallowancesbulk', [

                'uses' => 'AdminController@activateallowancesbulk',

                'as' => 'activateallowancesbulk'

            ]);
            Route::post('deactivateallowancesbulk', [

                'uses' => 'AdminController@deactivateallowancesbulk',

                'as' => 'deactivateallowancesbulk'

            ]);
            Route::post('Deleteallowancesbulk', [

                'uses' => 'AdminController@Deleteallowancesbulk',

                'as' => 'Deleteallowancesbulk'

            ]);
            Route::post('deactivatetimeshetsbulk', [

                'uses' => 'AdminController@deactivatetimeshetsbulk',

                'as' => 'deactivatetimeshetsbulk'

            ]);
            Route::post('activatetimeshetsbulk', [

                'uses' => 'AdminController@activatetimeshetsbulk',

                'as' => 'activatetimeshetsbulk'

            ]);
            Route::post('deletetimeshetsbulk', [

                'uses' => 'AdminController@deletetimeshetsbulk',

                'as' => 'deletetimeshetsbulk'

            ]);
            Route::post('deactivateexpensebulk', [

                'uses' => 'AdminController@deactivateexpensebulk',

                'as' => 'deactivateexpensebulk'

            ]);
            Route::post('activateexpensebulk', [

                'uses' => 'AdminController@activateexpensebulk',

                'as' => 'activateexpensebulk'

            ]);
            Route::post('deleteexpensebulk', [

                'uses' => 'AdminController@deleteexpensebulk',

                'as' => 'deleteexpensebulk'

            ]);
        }

        if ($_SESSION['RouteCheckee'] == 0) {
            ///////////////////////// JOBS ///////////////////////////////


            Route::get('Addjob', [

                'uses' => 'AdminController@addjob',

                //'as'=>'addstaff'

            ]);



            Route::get('Alljobs', [

                'uses' => 'AdminController@alljobs',

                //'as'=>'addstaff'

            ]);



            Route::get('deletejob/{id}', [

                'uses' => 'AdminController@deletejob',

                'as' => 'deletejob'



            ]);



            Route::get('activatejob/{id}', [

                'uses' => 'AdminController@activatejob',

                'as' => 'activatejob'



            ]);



            Route::get('deactivatejob/{id}', [

                'uses' => 'AdminController@deactivatejob',

                'as' => 'deactivatejob'



            ]);



            Route::get('editjob/{id}', [

                'uses' => 'AdminController@editjob',

                'as' => 'editjob'



            ]);



            Route::post('Updatejob', [

                'uses' => 'AdminController@Updatejob',

                'as' => 'Updatejob'



            ]);



            Route::post('STOREjob', [

                'uses' => 'AdminController@STOREjob',

                'as' => 'STOREjob'

            ]);








            Route::post('Updatestaff/{id}', [

                'uses' => 'AdminController@Updatestaff',

                'as' => 'Updatestaff'



            ]);



            Route::get('AddAgency', [

                'uses' => 'AdminController@agency',

                'as' => 'addagency'

            ]);



            Route::post('STOREAGENCY', [

                'uses' => 'AdminController@STOREAGENCY',

                'as' => 'STOREAGENCY'

            ]);



            Route::get('AllAgencies', [

                'uses' => 'AdminController@allagencies',

                'as' => 'allagencies'

            ]);


            Route::get('AllAgenciesIn', [

                'uses' => 'AdminController@allagenciesin',

                'as' => 'allagenciesin'

            ]);



            Route::get('deleteagency/{id}', [

                'uses' => 'AdminController@deleteagency',

                'as' => 'deleteagency'

            ]);



            Route::get('editagency/{id}', [

                'uses' => 'AdminController@editagency',

                'as' => 'editagency'

            ]);



            Route::post('updateagency/{id}', [

                'uses' => 'AdminController@updateagency',

                'as' => 'updateagency'

            ]);



            Route::get('deactivateagency/{id}', [

                'uses' => 'AdminController@deactivateagency',

                'as' => 'deactivateagency'

            ]);



            Route::get('activateagency/{id}', [

                'uses' => 'AdminController@activateagency',

                'as' => 'activateagency'

            ]);

            //ending agency section here



            //driver methods stargin form here====================>

            Route::get('AllDrivers', [

                'uses' => 'AdminController@alldrivers',

                'as' => 'alldrivers'

            ]);

            Route::post('datatable_alldrivers', 'AdminController@datatable_alldrivers');

            Route::get('CHDetails/{Check}/{MainID}/{ID?}', [

                'uses' => 'AdminController@CHDetails',

                'as' => 'CHDetails'

            ]);

            // Route::get('CHDetails/{ID}',[

            // 'uses'=>'AdminController@CHDetails_Submit',

            // 'as'=>'CHDetails'

            // ]);

            Route::get('AllDriversIn', [

                'uses' => 'AdminController@alldriversin',

                'as' => 'alldriversin'

            ]);



            Route::post('storedrivers', [

                'uses' => 'AdminController@storedrivers',

                'as' => 'storedrivers'

            ]);



            Route::get('AddDrivers', [

                'uses' => 'AdminController@adddrivers',

                'as' => 'adddrivers'

            ]);


            Route::get('Devices', [

                'uses' => 'AdminController@Devices',

                'as' => 'Devices'

            ]);


            Route::get('DeleteDevice/{ID}', [

                'uses' => 'AdminController@DeleteDevice',

                'as' => 'DeleteDevice'

            ]);


            Route::get('deactivatedriver/{id}', [

                'uses' => 'AdminController@deactivatedriver',

                'as' => 'deactivatedriver'

            ]);



            Route::get('activatedriver/{id}', [

                'uses' => 'AdminController@activatedriver',

                'as' => 'activatedriver'

            ]);



            Route::get('deletedriver/{id}', [

                'uses' => 'AdminController@deletedriver',

                'as' => 'deletedriver'

            ]);



            Route::get('editdriver/{id}', [

                'uses' => 'AdminController@editdriver',

                'as' => 'editdriver'



            ]);



            Route::post('Updatedriver/{id}', [

                'uses' => 'AdminController@Updatedriver',

                'as' => 'Updatedriver'



            ]);



            Route::get('DriverProfile/{id}', [

                'uses' => 'AdminController@DriverProfile',

                'as' => 'DriverProfile'



            ]);

            if ($_SESSION['Accountancy'] == 1) {

                Route::get('activateallowances/{id}', [

                    'uses' => 'AdminController@activateallowances',

                    'as' => 'activateallowances'



                ]);



                Route::get('deactivateallowances/{id}', [

                    'uses' => 'AdminController@deactivateallowances',

                    'as' => 'deactivateallowances'



                ]);

                Route::get('EditAllowances/{ID}', 'AdminController@EditAllowances');

                Route::post('AddAllowances', 'AdminController@AddAllowances');


                Route::get('deactivatetimeshets/{id}', [

                    'uses' => 'AdminController@deactivatetimeshets',

                    'as' => 'deactivatetimeshets'

                ]);



                Route::get('activatetimeshets/{id}', [

                    'uses' => 'AdminController@activatetimeshets',

                    'as' => 'activatetimeshets'

                ]);



                Route::get('deletetimeshets/{id}', [

                    'uses' => 'AdminController@deletetimeshets',

                    'as' => 'deletetimeshets'

                ]);



                Route::get('edittimesheets/{Type}/{id}', [

                    'uses' => 'AdminController@edittimeshets',

                    'as' => 'edittimeshets'



                ]);

                Route::get('Attachment/{ID}', [

                    'uses' => 'AdminController@Attachment',

                    'as' => 'Attachment'



                ]);



                Route::post('Updatetimeshets/{id}', [

                    'uses' => 'AdminController@Updatetimeshets',

                    'as' => 'Updatetimeshets'



                ]);

                Route::get('Invoice/{Check}/{ID}', 'AdminController@Invoice');

                Route::get('invoiced/{ID}/{Check}', 'AdminController@invoiced');



                Route::get('deactivatecertified/{id}', [

                    'uses' => 'AdminController@deactivatecertified',

                    'as' => 'deactivatecertified'

                ]);



                Route::get('activatecertified/{id}', [

                    'uses' => 'AdminController@activatecertified',

                    'as' => 'activatecertified'

                ]);



                Route::get('deletecertified/{id}', [

                    'uses' => 'AdminController@deletecertified',

                    'as' => 'deletecertified'

                ]);



                Route::get('editcertified/{id}', [

                    'uses' => 'AdminController@editcertified',

                    'as' => 'editcertified'



                ]);



                Route::post('Updatecertified/{id}', [

                    'uses' => 'AdminController@Updatecertified',

                    'as' => 'Updatecertified'



                ]);



                Route::get('deactivateexpense/{id}', [

                    'uses' => 'AdminController@deactivateexpense',

                    'as' => 'deactivateexpense'

                ]);



                Route::get('activateexpense/{id}', [

                    'uses' => 'AdminController@activateexpense',

                    'as' => 'activateexpense'

                ]);



                Route::get('deleteexpense/{id}', [

                    'uses' => 'AdminController@deleteexpense',

                    'as' => 'deleteexpense'

                ]);



                Route::get('editexpense/{id}', [

                    'uses' => 'AdminController@editexpense',

                    'as' => 'editexpense'



                ]);



                Route::post('Updateexpense/{id}', [

                    'uses' => 'AdminController@Updateexpense',

                    'as' => 'Updateexpense'



                ]);


                Route::get('/HGVAccountancy', 'AdminController@WT');

                Route::get('/EnhancedDriver', 'AdminController@EnhancedDriver');

                Route::get('/driverown', 'AdminController@driverown');

                Route::get('/DriverInvoice', 'AdminController@DriverInvoice');

                Route::get('/agencyselfbill', 'AdminController@agencyselfbill');

                Route::get('/WIE', 'AdminController@WIE');

                Route::get('/MES', 'AdminController@MES');
            }
        } else {
            ///////////////////////// JOBS ///////////////////////////////


            Route::get('Addjob', [

                'uses' => 'AdminController@addjob',

                //'as'=>'addstaff'

            ]);

            Route::get('AgencyDrivers/{Check}', [

                'uses' => 'AdminController@AgencyDrivers',

                'as' => 'AgencyDrivers'

            ]);

            Route::get('AssignedDrivers/{Check}/{ID}', [

                'uses' => 'AdminController@AssignedDrivers',

                'as' => 'AssignedDrivers'

            ]);

            Route::post('AssignedDriversNew', [

                'uses' => 'AdminController@AssignedDriversNew',

            ]);

            Route::get('AllDrivers', [

                'uses' => 'AdminController@alldrivers',

                'as' => 'alldrivers'

            ]);

            Route::post('datatable_alldrivers', 'AdminController@datatable_alldrivers');


            Route::get('Alljobs', [

                'uses' => 'AdminController@alljobs',

                //'as'=>'addstaff'

            ]);



            Route::get('deletejob/{id}', [

                'uses' => 'AdminController@deletejob',

                'as' => 'deletejob'



            ]);



            Route::get('activatejob/{id}', [

                'uses' => 'AdminController@activatejob',

                'as' => 'activatejob'



            ]);



            Route::get('deactivatejob/{id}', [

                'uses' => 'AdminController@deactivatejob',

                'as' => 'deactivatejob'



            ]);



            Route::get('editjob/{id}', [

                'uses' => 'AdminController@editjob',

                'as' => 'editjob'



            ]);



            Route::post('Updatejob', [

                'uses' => 'AdminController@Updatejob',

                'as' => 'Updatejob'



            ]);



            Route::post('STOREjob', [

                'uses' => 'AdminController@STOREjob',

                'as' => 'STOREjob'

            ]);

            Route::post('Updatestaff/{id}', [

                'uses' => 'AdminController@Updatestaff',

                'as' => 'Updatestaff'



            ]);

            //ending agency section here
            //driver methods stargin form here====================>

            Route::get('DriverProfile/{id}', [

                'uses' => 'AdminController@DriverProfile',

                'as' => 'DriverProfile'



            ]);



            if ($_SESSION['Accountancy'] == 1) {

                Route::get('activateallowances/{id}', [

                    'uses' => 'AdminController@activateallowances',

                    'as' => 'activateallowances'



                ]);



                Route::get('deactivateallowances/{id}', [

                    'uses' => 'AdminController@deactivateallowances',

                    'as' => 'deactivateallowances'



                ]);

                Route::get('EditAllowances/{ID}', 'AdminController@EditAllowances');

                Route::post('AddAllowances', 'AdminController@AddAllowances');


                Route::get('deactivatetimeshets/{id}', [

                    'uses' => 'AdminController@deactivatetimeshets',

                    'as' => 'deactivatetimeshets'

                ]);



                Route::get('activatetimeshets/{id}', [

                    'uses' => 'AdminController@activatetimeshets',

                    'as' => 'activatetimeshets'

                ]);



                Route::get('deletetimeshets/{id}', [

                    'uses' => 'AdminController@deletetimeshets',

                    'as' => 'deletetimeshets'

                ]);



                Route::get('edittimesheets/{Type}/{id}', [

                    'uses' => 'AdminController@edittimeshets',

                    'as' => 'edittimeshets'



                ]);

                Route::get('Attachment/{ID}', [

                    'uses' => 'AdminController@Attachment',

                    'as' => 'Attachment'



                ]);



                Route::post('Updatetimeshets/{id}', [

                    'uses' => 'AdminController@Updatetimeshets',

                    'as' => 'Updatetimeshets'



                ]);

                Route::get('Invoice/{Check}/{ID}', 'AdminController@Invoice');

                Route::get('invoiced/{ID}/{Check}', 'AdminController@invoiced');



                Route::get('deactivatecertified/{id}', [

                    'uses' => 'AdminController@deactivatecertified',

                    'as' => 'deactivatecertified'

                ]);



                Route::get('activatecertified/{id}', [

                    'uses' => 'AdminController@activatecertified',

                    'as' => 'activatecertified'

                ]);



                Route::get('deletecertified/{id}', [

                    'uses' => 'AdminController@deletecertified',

                    'as' => 'deletecertified'

                ]);



                Route::get('editcertified/{id}', [

                    'uses' => 'AdminController@editcertified',

                    'as' => 'editcertified'



                ]);



                Route::post('Updatecertified/{id}', [

                    'uses' => 'AdminController@Updatecertified',

                    'as' => 'Updatecertified'



                ]);



                Route::get('deactivateexpense/{id}', [

                    'uses' => 'AdminController@deactivateexpense',

                    'as' => 'deactivateexpense'

                ]);



                Route::get('activateexpense/{id}', [

                    'uses' => 'AdminController@activateexpense',

                    'as' => 'activateexpense'

                ]);



                Route::get('deleteexpense/{id}', [

                    'uses' => 'AdminController@deleteexpense',

                    'as' => 'deleteexpense'

                ]);



                Route::get('editexpense/{id}', [

                    'uses' => 'AdminController@editexpense',

                    'as' => 'editexpense'



                ]);



                Route::post('Updateexpense/{id}', [

                    'uses' => 'AdminController@Updateexpense',

                    'as' => 'Updateexpense'



                ]);


                Route::get('/HGVAccountancy', 'AdminController@WT');

                Route::get('/EnhancedDriver', 'AdminController@EnhancedDriver');

                Route::get('/driverown', 'AdminController@driverown');

                Route::get('/DriverInvoice', 'AdminController@DriverInvoice');

                Route::get('/agencyselfbill', 'AdminController@agencyselfbill');

                Route::get('/WIE', 'AdminController@WIE');

                Route::get('/MES', 'AdminController@MES');
            }
        }
    }
});



//////////////////////////////// AGENCY ////////////////////////////////////////



Route::group(['middleware' => 'agency'], function () {

    if ($_SESSION['adminController'] == 3) {

        //////////////////// Bulk Routes ////////////////////
        Route::post('deletejobbulk', [

            'uses' => 'AdminController@deletejobbulk',

            'as' => 'deletejobbulk'

        ]);
        Route::post('activatejobbulk', [

            'uses' => 'AdminController@activatejobbulk',

            'as' => 'activatejobbulk'

        ]);
        Route::post('deactivatejobbulk', [

            'uses' => 'AdminController@deactivatejobbulk',

            'as' => 'deactivatejobbulk'

        ]);
        Route::post('Deletestaffbulk', [

            'uses' => 'AdminController@deletestaffbulk',

            'as' => 'Deletestaffbulk'

        ]);
        Route::post('activatestaffbulk', [

            'uses' => 'AdminController@activatestaffbulk',

            'as' => 'activatestaffbulk'

        ]);
        Route::post('deactivatestaffbulk', [

            'uses' => 'AdminController@deactivatestaffbulk',

            'as' => 'deactivatestaffbulk'

        ]);
        Route::post('deactivatedriverbulk', [

            'uses' => 'AdminController@deactivatedriverbulk',

            'as' => 'deactivatedriverbulk'

        ]);
        Route::post('activatedriverbulk', [

            'uses' => 'AdminController@activatedriverbulk',

            'as' => 'activatedriverbulk'

        ]);
        Route::post('deletedriverbulk', [

            'uses' => 'AdminController@deletedriverbulk',

            'as' => 'deletedriverbulk'

        ]);


            Route::post('activateallowancesbulk', [

                'uses' => 'AdminController@activateallowancesbulk',

                'as' => 'activateallowancesbulk'

            ]);
            Route::post('deactivateallowancesbulk', [

                'uses' => 'AdminController@deactivateallowancesbulk',

                'as' => 'deactivateallowancesbulk'

            ]);
            Route::post('Deleteallowancesbulk', [

                'uses' => 'AdminController@Deleteallowancesbulk',

                'as' => 'Deleteallowancesbulk'

            ]);
            Route::post('deactivatetimeshetsbulk', [

                'uses' => 'AdminController@deactivatetimeshetsbulk',

                'as' => 'deactivatetimeshetsbulk'

            ]);
            Route::post('activatetimeshetsbulk', [

                'uses' => 'AdminController@activatetimeshetsbulk',

                'as' => 'activatetimeshetsbulk'

            ]);
            Route::post('deletetimeshetsbulk', [

                'uses' => 'AdminController@deletetimeshetsbulk',

                'as' => 'deletetimeshetsbulk'

            ]);
            Route::post('deactivateexpensebulk', [

                'uses' => 'AdminController@deactivateexpensebulk',

                'as' => 'deactivateexpensebulk'

            ]);
            Route::post('activateexpensebulk', [

                'uses' => 'AdminController@activateexpensebulk',

                'as' => 'activateexpensebulk'

            ]);
            Route::post('deleteexpensebulk', [

                'uses' => 'AdminController@deleteexpensebulk',

                'as' => 'deleteexpensebulk'

            ]);

        Route::get('Addjob', [

            'uses' => 'AdminController@addjob',

            //'as'=>'addstaff'

        ]);



        Route::get('Alljobs', [

            'uses' => 'AdminController@alljobs',

            //'as'=>'addstaff'

        ]);



        Route::get('deletejob/{id}', [

            'uses' => 'AdminController@deletejob',

            'as' => 'deletejob'



        ]);



        Route::get('activatejob/{id}', [

            'uses' => 'AdminController@activatejob',

            'as' => 'activatejob'



        ]);



        Route::get('deactivatejob/{id}', [

            'uses' => 'AdminController@deactivatejob',

            'as' => 'deactivatejob'



        ]);



        Route::get('editjob/{id}', [

            'uses' => 'AdminController@editjob',

            'as' => 'editjob'



        ]);



        Route::post('Updatejob', [

            'uses' => 'AdminController@Updatejob',

            'as' => 'Updatejob'



        ]);



        Route::post('STOREjob', [

            'uses' => 'AdminController@STOREjob',

            'as' => 'STOREjob'

        ]);





        //////////////////////////////  STAFF ///////////////////////////



        Route::get('AddStaff', [

            'uses' => 'AdminController@staff',

            'as' => 'addstaff'

        ]);



        Route::post('STORESTAFF', [

            'uses' => 'AdminController@STORESTAFF',

            'as' => 'STORESTAFF'

        ]);



        Route::get('AllStaff', [

            'uses' => 'AdminController@allstaff',

            'as' => 'allstaff'

        ]);



        Route::get('Deletestaff/{id}', [

            'uses' => 'AdminController@deletestaff',

            'as' => 'deletestaff'



        ]);



        Route::get('activatestaff/{id}', [

            'uses' => 'AdminController@activatestaff',

            'as' => 'activatestaff'



        ]);



        Route::get('deactivatestaff/{id}', [

            'uses' => 'AdminController@deactivatestaff',

            'as' => 'deactivatestaff'



        ]);



        Route::get('editstaff/{id}', [

            'uses' => 'AdminController@editstaff',

            'as' => 'editstaff'



        ]);



        Route::post('Updatestaff/{id}', [

            'uses' => 'AdminController@Updatestaff',

            'as' => 'Updatestaff'



        ]);
        Route::get('Allowances/', [

            'uses' => 'AdminController@Allowances',

            'as' => 'Allowances Settings'

        ]);

        Route::get('ListAllowances/', [

            'uses' => 'AdminController@ListAllowances',

            'as' => 'Allowances Settings'

        ]);

        Route::get('Deleteallowances/{id}', [

            'uses' => 'AdminController@deleteallowances',

            'as' => 'deleteallowances'



        ]);



        Route::get('activateallowances/{id}', [

            'uses' => 'AdminController@activateallowances',

            'as' => 'activateallowances'



        ]);



        Route::get('deactivateallowances/{id}', [

            'uses' => 'AdminController@deactivateallowances',

            'as' => 'deactivateallowances'



        ]);

        Route::post('AddAllowances', 'AdminController@AddAllowances');

        Route::get('EditAllowances/{ID}', 'AdminController@EditAllowances');

        Route::post('updateagency/{id}', [

            'uses' => 'AdminController@updateagency',

            'as' => 'updateagency'

        ]);



        Route::get('AgencyDrivers/{Check}', [

            'uses' => 'AdminController@AgencyDrivers',

            'as' => 'AgencyDrivers'

        ]);


        Route::get('AssignedDrivers/{Check}/{ID}', [

            'uses' => 'AdminController@AssignedDrivers',

            'as' => 'AssignedDrivers'

        ]);


        Route::post('AssignedDriversNew', [

            'uses' => 'AdminController@AssignedDriversNew',

        ]);


        Route::get('AllDrivers', [

            'uses' => 'AdminController@alldrivers',

            'as' => 'alldrivers'

        ]);

        Route::post('datatable_alldrivers', 'AdminController@datatable_alldrivers');



        Route::get('DriverProfile/{id}', [

            'uses' => 'AdminController@DriverProfile',

            'as' => 'DriverProfile'



        ]);



        if ($_SESSION['Accountancy'] == 1) {

            Route::get('activateallowances/{id}', [

                'uses' => 'AdminController@activateallowances',

                'as' => 'activateallowances'



            ]);



            Route::get('deactivateallowances/{id}', [

                'uses' => 'AdminController@deactivateallowances',

                'as' => 'deactivateallowances'



            ]);

            Route::get('EditAllowances/{ID}', 'AdminController@EditAllowances');

            Route::post('AddAllowances', 'AdminController@AddAllowances');


            Route::get('deactivatetimeshets/{id}', [

                'uses' => 'AdminController@deactivatetimeshets',

                'as' => 'deactivatetimeshets'

            ]);



            Route::get('activatetimeshets/{id}', [

                'uses' => 'AdminController@activatetimeshets',

                'as' => 'activatetimeshets'

            ]);



            Route::get('deletetimeshets/{id}', [

                'uses' => 'AdminController@deletetimeshets',

                'as' => 'deletetimeshets'

            ]);



            Route::get('edittimesheets/{Type}/{id}', [

                'uses' => 'AdminController@edittimeshets',

                'as' => 'edittimeshets'



            ]);

            Route::get('Attachment/{ID}', [

                'uses' => 'AdminController@Attachment',

                'as' => 'Attachment'



            ]);



            Route::post('Updatetimeshets/{id}', [

                'uses' => 'AdminController@Updatetimeshets',

                'as' => 'Updatetimeshets'



            ]);

            Route::get('Invoice/{Check}/{ID}', 'AdminController@Invoice');

            Route::get('invoiced/{ID}/{Check}', 'AdminController@invoiced');



            Route::get('deactivatecertified/{id}', [

                'uses' => 'AdminController@deactivatecertified',

                'as' => 'deactivatecertified'

            ]);



            Route::get('activatecertified/{id}', [

                'uses' => 'AdminController@activatecertified',

                'as' => 'activatecertified'

            ]);



            Route::get('deletecertified/{id}', [

                'uses' => 'AdminController@deletecertified',

                'as' => 'deletecertified'

            ]);



            Route::get('editcertified/{id}', [

                'uses' => 'AdminController@editcertified',

                'as' => 'editcertified'



            ]);



            Route::post('Updatecertified/{id}', [

                'uses' => 'AdminController@Updatecertified',

                'as' => 'Updatecertified'



            ]);



            Route::get('deactivateexpense/{id}', [

                'uses' => 'AdminController@deactivateexpense',

                'as' => 'deactivateexpense'

            ]);



            Route::get('activateexpense/{id}', [

                'uses' => 'AdminController@activateexpense',

                'as' => 'activateexpense'

            ]);



            Route::get('deleteexpense/{id}', [

                'uses' => 'AdminController@deleteexpense',

                'as' => 'deleteexpense'

            ]);



            Route::get('editexpense/{id}', [

                'uses' => 'AdminController@editexpense',

                'as' => 'editexpense'



            ]);



            Route::post('Updateexpense/{id}', [

                'uses' => 'AdminController@Updateexpense',

                'as' => 'Updateexpense'



            ]);


            Route::get('/HGVAccountancy', 'AdminController@WT');

            Route::get('/EnhancedDriver', 'AdminController@EnhancedDriver');

            Route::get('/driverown', 'AdminController@driverown');

            Route::get('/DriverInvoice', 'AdminController@DriverInvoice');

            Route::get('/agencyselfbill', 'AdminController@agencyselfbill');

            Route::get('/WIE', 'AdminController@WIE');

            Route::get('/MES', 'AdminController@MES');
        }
    }
});



/////////////////////////////// DRIVERS /////////////////////////////////////////





// NOT ALLOWED TO LOGIN























//ending staff section here
