<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\User;
use App\Employee;

class AuthController extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth:api', ['except' => ['login']]);
    }

    /**
     * Get a JWT via given credentials.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function login()
    {
        $credentials = request(['email', 'password']);

        $user = User::where("email", $credentials['email'])->first();

        if ($user) {
            if (Hash::check($credentials['password'], $user->password)) {
                return [
                    'status' => 200,
                    'message' => 'logged_in_successfully',
                    'profile' => $user
                ];
            } else {
                return [
                    'status' => 100,
                    'message' => 'email_or_password_is_invalid'
                ];
            }
        }
    }
    public function employee_login()
    {
        $credentials = request(['email', 'password']);

        $user = Employee::where("email", $credentials['email'])->first();

        if ($user) {
            if (Hash::check($credentials['password'], $user->password)) {
                return [
                    'status' => 200,
                    'message' => 'logged_in_successfully',
                    'profile' => $user
                ];
            } else {
                return [
                    'status' => 100,
                    'message' => 'email_or_password_is_invalid'
                ];
            }
        }
    }

    public function signup()
    {
        // dd("working");
        $request = request(['email', 'password', "first_name", "last_name", "username", "type"]);
        $username = User::where("username", $request['username'])->first();
        if ($username) {
            return [
                'status' => 100,
                "message" => "username_already_exist"
            ];
        }
        $email = User::where("email", $request['email'])->first();
        if ($email) {
            return [
                'status' => 100,
                "message" => "email_already_exist"
            ];
        }
        User::create([
            'email' => $request['email'],
            'password' => bcrypt($request['password']),
            'first_name' => $request['first_name'],
            'last_name' => $request['last_name'],
            'username' => $request['username'],
            'type' => $request['type'],
        ]);

        $user = User::where("email", $request['email'])->first();

        return [
            'status' => 200,
            'message' => 'email_or_password_is_invalid',
            'profile' => $user
        ];
    }

    public function confirmEmail()
    {
        // dd("working");
        $request = request(['email']);
        $user = User::where("email", $request['email'])->select(["id"])->first();
        if ($user) {
            return [
                'status' => 200,
                "message" => "email_found",
                "id" => $user->id
            ];
        } else {
            return [
                'status' => 100,
            ];
        }
    }

    public function employeeConfirmEmail()
    {
        // dd("working");
        $request = request(['email']);
        $user = Employee::where("email", $request['email'])->select(["id"])->first();
        if ($user) {
            return [
                'status' => 200,
                "message" => "email_found",
                "id" => $user->id
            ];
        } else {
            return [
                'status' => 100,
            ];
        }
    }

    public function resetPassword()
    {
        // dd("working");
        $request = request(['id', 'password']);
        $user = User::where("id", $request['id'])->first();
        if ($user) {
            $user->password = bcrypt($request['password']);
            $user->save();
            return [
                'status' => 200,
                "message" => "password_changes_successfully"
            ];
        } else {
            return [
                'status' => 100,
            ];
        }
    }

    public function employeeResetPassword()
    {
        // dd("working");
        $request = request(['id', 'password']);
        $user = Employee::where("id", $request['id'])->first();
        if ($user) {
            $user->password = bcrypt($request['password']);
            $user->save();
            return [
                'status' => 200,
                "message" => "password_changes_successfully"
            ];
        } else {
            return [
                'status' => 100,
            ];
        }
    }

    /**
     * Get the authenticated User.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function me()
    {
        return response()->json(auth('api')->user());
    }

    /**
     * Log the user out (Invalidate the token).
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        auth()->logout();

        return response()->json(['message' => 'Successfully logged out']);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth('api')->refresh());
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth('api')->factory()->getTTL() * 60,
            'profile' => auth('api')->user(),
            'status' => 200
        ]);
    }
}
