<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use App\Project;
use App\Job;
use App\Building;
use App\Employee;
use App\Message;
use App\Reply;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\UploadedFile;

class EmployeeController extends Controller
{
    public function getEmployeeFormData($id)
    {
        return [
            "status" => 200,
            'message' => "",
            'jobs' => Job::where('created_by', $id)->get()
        ];
    }

    public function addEmployee($id, Request $request)
    {
        // return $request;
        $filename = null;
        $file = $request->image;
        if ($file) {
            $destinationPath = public_path('uploads/');
            $originalFile = $file->getClientOriginalName();
            $filename = strtotime(date('Y-m-d-H:isa')) . $originalFile;
            $file->move($destinationPath, $filename);
        }
        if ($filename) {
            $filename =  $filename;
        }

        Employee::create([
            'name'       => $request->name,
            'address'    => $request->address,
            'zip_code'   => $request->zip_code,
            'city'       => $request->city,
            'phone'      => $request->phone,
            'email'      => $request->email,
            'password'   => bcrypt($request->password),
            'position'   => $request->position,
            'image'      => $filename,
            'created_by' => $id,
        ]);

        return [
            "status" => 200,
            'message' => "employee_added_successfully"
        ];
    }

    public function updateEmployee($id, Request $request)
    {
        $filename = null;
        $file = $request->image;
        $employee = Employee::where('id', $request->id)->first();
        if ($file) {
            $destinationPath = public_path('uploads/');
            $originalFile = $file->getClientOriginalName();
            $filename = strtotime(date('Y-m-d-H:isa')) . $originalFile;
            $file->move($destinationPath, $filename);
            $filename = $filename;
        } else {
            $filename = $employee->image;
        }

        Employee::where("id", $request->id)->update([
            'name'     => $request->name,
            'address'  => $request->address,
            'zip_code' => $request->zip_code,
            'city'     => $request->city,
            'phone'    => $request->phone,
            'email'    => $request->email,
            'position' => $request->position,
            'image'    => $filename,
        ]);

        $messages = Message::where('employee_id', $id)->get();

        foreach ($messages as $message) {
            $message->name  = $request->name;
            $message->phone = $request->phone;
            $message->save();
        }

        return [
            "status"  => 200,
            'message' => "employee_added_successfully"
        ];
    }


    public function getEmployees($id)
    {
        return [
            'status' => 200,
            'message' => "Employees Data Fetched Successfully",
            'employees' => Employee::where('created_by', $id)->get()
        ];
    }

    public function getMyMessages($id)
    {
        $messages = Message::where('employee_id', $id)->orderBy("id", "desc")->get();

        foreach ($messages as $message) {
            $project = Project::where("id", $message->project_id)->first();
            // $replies = Reply::where('message_id', $message->id)->get();
            $message->setAttribute("task", $project);
            // $message->setAttribute("replies", $replies);
        }

        return [
            'status' => 200,
            'message' => "Employees Data Fetched Successfully",
            'messages' => $messages
        ];
    }

    public function getReplies($id)
    {
        return [
            'status' => 200,
            'message' => "Fetched",
            'replies' => Reply::where('message_id', $id)->get()
        ];
    }

    public function addNewReply(request $request)
    {
        $reply = new Reply();
        $reply->message_id = $request->message_id;
        $reply->text = $request->text;

        $filename = "";
        $file = $request->file("file");
        if ($file) {
            $destinationPath = public_path('uploads/');
            $originalFile = $file->getClientOriginalName();
            $filename = strtotime(date('Y-m-d-H:isa')) . $originalFile;
            $file->move($destinationPath, $filename);
        }
        if ($filename) {
            $filename = $filename;
        }
        $reply->file = $filename;
        $reply->save();

        return [
            'status' => 200,
            'message' => "Fetched",
        ];
    }
}
